<?php
defined('BASEPATH') OR exit('No direct script access allowed');
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
class Laporan extends CI_Controller {

	function __construct() {
		parent::__construct();
		//validasi jika user belum login
		if ($this->session->userdata('masuk') != TRUE) {
			$url = base_url();
			redirect($url);
		}

//		if ($this->session->userdata('akses') != 'manager') {
//			$url = base_url('dashboard/');
//			redirect($url);
	//	}
		date_default_timezone_set('Asia/Jakarta');
		$this->load->model('laporan_model');
		$this->load->helper('random');
	}
	
	 public function test(){
        $spreadsheet = new Spreadsheet();
        /* $sheet = $spreadsheet->getActiveSheet(); */
        $spreadsheet->setActiveSheetIndex(0)->setCellValue('A1', 'Hello');
        /* Rename worksheet */
        $spreadsheet->getActiveSheet()->setTitle('URL Added');
        $spreadsheet->createSheet();
        /* Add some data */
        $spreadsheet->setActiveSheetIndex(1)->setCellValue('A1', 'world!');
        /* Rename worksheet */
        $spreadsheet->getActiveSheet()->setTitle('URL Removed');
        $writer = new Xlsx($spreadsheet);
        $filename=date("d-m-Y").time();
        $writer->save("./uploads/dsr/excel/bl/$filename.xlsx");
    }

	public function retur() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['totalretur'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['retur'] = $this->laporan_model->getDataReturFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['retur'] = $this->laporan_model->getDataRetur($tanggal);
		}
		$this->load->view('laporan/retur', $data);
	}

	public function biaya() {
		$data['bulan'] = date('m');
		$this->load->view('header', $data, FALSE);
		$this->load->view('laporan/biaya');
	}
	
	public function view_biaya() {
		$tipe = $this->input->post('action');
		$bulan = $this->input->post('bulan');
		$tahun = $this->input->post('tahun');
		$tgl_awal = $tahun . "-" . $bulan . "-01";
		$tgl_akhir = $tahun . "-" . $bulan . "-31";
		$data['toko'] = $this->laporan_model->get_toko();
		$data['bln'] = $bulan;
		$data['thn'] = $tahun;
		if ($tipe == 'Rekap') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_a'] = 0;
			$data['tot_b'] = 0;
			$data['tot_c'] = 0;
			$data['tot_d'] = 0;
			$data['tot_tot'] = 0;
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRekap($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_pengeluaran_rekap', $data, FALSE);
		} elseif ($tipe == 'Rinci') {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci($tgl_awal, $tgl_akhir);
			$this->load->view('laporan/lap_pengeluaran_rinci', $data, FALSE);
		}
	}
	

	public function nilai_persediaan() {
		$nilai_persediaan = $this->laporan_model->getNilaiPersediaan();
		$data['toko'] = $this->laporan_model->get_toko();
		if ($nilai_persediaan) {
			$data['no'] = 1;
			$data['tot'] = 0;
			$data['tot_beli'] = 0;
			$data['tot_jual'] = 0;
			$data['tot_nbeli'] = 0;
			$data['tot_njual'] = 0;
			$data['nilai_modal'] = 0;
			$data['nilai_jual'] = 0;
			$data['nilai_persediaan'] = $nilai_persediaan;
			$this->load->view('laporan/lap_nilai_persediaan', $data, FALSE);
		}
	}

	public function pembelian() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['tot_harga'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['pembelian'] = $this->laporan_model->getDataPembelianFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['pembelian'] = $this->laporan_model->getDataPembelian($tanggal);
		}
		$this->load->view('laporan/pembelian', $data);
	}

	public function penjualan_transaksi() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanTransaksi($tanggal);
		}
		$this->load->view('laporan/penjualan_transaksi', $data);
	}
	
	public function broadcast() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$bulan = date('m');
		$tahun = date('Y');
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['broadcast'] = $this->laporan_model->getDatabroadcastfilter($tgl_awal, $tgl_akhir);
		} else {
			$data['broadcast'] = $this->laporan_model->getDatabroadcast($bulan,$tahun);
		}
		$this->load->view('laporan/broadcast', $data);
	}
	public function pembelian_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDatamutasiTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDatamutasiTransaksi($tanggal);
		}
		$this->load->view('laporan/pembelian_transaksi', $data);
	}
	public function produksi_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataproduksiTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataproduksiTransaksi($tanggal);
		}
		$this->load->view('laporan/produksi_transaksi', $data);
	}
	
	public function promo_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDatapromoTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDatapromoTransaksi($tanggal);
		}
		$this->load->view('laporan/promo_transaksi', $data);
	}
	
	
	public function keluar_transaksi() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['subtot'] = 0;
		$data['diskon'] = 0;
		$data['grandtot'] = 0;
		$data['cash'] = 0;
		$data['debet'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDatakeluarTransaksiFilter($tgl_awal, $tgl_akhir);
		} else {
			$data['penjualan'] = $this->laporan_model->getDatakeluarTransaksi($tanggal);
		}
		$this->load->view('laporan/keluar_transaksi', $data);
	}	

	public function barcode() {
        $kdtoko = $this->session->userdata('kd_toko');			    
		$tanggal = date('Y-m-d');
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$this->load->view('kasir/scanbarcode', $data);
	}	
	public function penjualan_barang() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$jenis=$a;
		$jual=$b;
		$ketjual='Semua';
		$ketjenis='Semua';
		if ($b=='s1') {$ketjual='Siang'; }
		if ($b=='s2') {$ketjual='Malam'; }
		
		if ($a=='al') {$ketjenis='Semua'; }
		if ($a=='tl') {$ketjenis='Total'; }
		if ($a=='do') {$ketjenis='DO'; }
		if ($a=='pr') {$ketjenis='Promo'; }
		if ($a=='ex') {$ketjenis='Promo Exp'; }
		if ($a=='mem') {$ketjenis='Promo Member'; }
		if ($a=='gf') {$ketjenis='Gofood'; }
		if ($a=='gr') {$ketjenis='Grabfood'; }
		if ($a=='sp') {$ketjenis='Shopeefood'; }
		if ($a=='rg') {$ketjenis='Reguler'; }
		
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totprorp'] = 0;
		$data['totproex'] = 0;
		$data['totprorpex'] = 0;
		$data['totpromem'] = 0;
		$data['totprorpmem'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['jenis'] = $jenis;
		$data['ketjenis'] = $ketjenis;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarangFilter($tgl_awal, $tgl_akhir,$jual);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarang($tanggal);
		}
		$this->load->view('laporan/penjualan_barang', $data);
	}
	
		public function penjualan_barang1() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter1');
		$kdtoko = $this->input->get('kedai');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$g = $this->input->get('g');
		$h = $this->input->get('h');
		$i = $this->input->get('i');
		
		$jenis=$a;
		$jual=$b;
		$ketjual='Semua';
		$ketjenis='Semua';
		if ($b=='s1') {$ketjual='Siang'; }
		if ($b=='s2') {$ketjual='Malam'; }
		
		if ($a=='al') {$ketjenis='Semua'; }
		if ($a=='tl') {$ketjenis='Total'; }
		if ($a=='do') {$ketjenis='DO'; }
		if ($a=='pr') {$ketjenis='Promo'; }
		if ($a=='gf') {$ketjenis='Gofood'; }
		if ($a=='gr') {$ketjenis='Grabfood'; }
		if ($a=='sp') {$ketjenis='Shopeefood'; }
		if ($a=='rg') {$ketjenis='Reguler'; }
		
		$tgl_akhir = $g . "-" . $h . "-" . $i;
		$tgl_awal = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['tot'] = 0;
		$data['totrp'] = 0;
		$data['totbrt'] = 0;
		$data['totppn'] = 0;
		$data['totreg'] = 0;
		$data['totregrp'] = 0;
		$data['totdo'] = 0;
		$data['totdorp'] = 0;
		$data['totpro'] = 0;
		$data['totproex'] = 0;
		$data['totprorpex'] = 0;
		$data['totpromem'] = 0;
		$data['totprorpmem'] = 0;
		$data['totprorp'] = 0;
		$data['totgf'] = 0;
		$data['totgfrp'] = 0;
		$data['totgr'] = 0;
		$data['totgrrp'] = 0;
		$data['totsf'] = 0;
		$data['totsfrp'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['jual'] = $ketjual;
		$data['jenis'] = $jenis;
		$data['ketjenis'] = $ketjenis;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_tokoku($kdtoko);
		if ($filter == "ok1") {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarangFilter1($tgl_awal, $tgl_akhir,$jual,$kdtoko);
		} else {
			$data['penjualan'] = $this->laporan_model->getDataPenjualanBarang1($tanggal,$kdtoko);
		}
		$this->load->view('laporan/penjualan_barang1', $data);
	}

	public function profit() {
		$tanggal = date('Y-m-d');
		$filter = $this->input->get('filter');
		$a = $this->input->get('a');
		$b = $this->input->get('b');
		$c = $this->input->get('c');
		$d = $this->input->get('d');
		$e = $this->input->get('e');
		$f = $this->input->get('f');
		$tgl_awal = $c . "-" . $b . "-" . $a;
		$tgl_akhir = $f . "-" . $e . "-" . $d;
		$data['tgl'] = date('d');
		$data['bln'] = date('m');
		$data['thn'] = date('Y');
		$data['no'] = 1;
		$data['noo'] = 1;
		$data['tot_item'] = 0;
		$data['tot_modal'] = 0;
		$data['tot_pendapatan'] = 0;
		$data['tot_profit'] = 0;
		$data['totbiaya'] = 0;
		$data['tanggal'] = $tanggal;
		$data['awal'] = $tgl_awal;
		$data['akhir'] = $tgl_akhir;
		$data['filter'] = $filter;
		$data['toko'] = $this->laporan_model->get_toko();
		if ($filter == "ok") {
			$data['profit'] = $this->laporan_model->getDataProfit($tgl_awal, $tgl_akhir);
			$data['subdiskon'] = $this->laporan_model->getDiskonBarang($tgl_awal, $tgl_akhir)->row();
			$data['subdisakhir'] = $this->laporan_model->getDiskonAkhir($tgl_awal, $tgl_akhir)->row();
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci($tgl_awal, $tgl_akhir);
		} else {
			$data['profit'] = $this->laporan_model->getDataProfit1($tanggal);
			$data['subdiskon'] = $this->laporan_model->getDiskonBarang1($tanggal)->row();
			$data['subdisakhir'] = $this->laporan_model->getDiskonAkhir1($tanggal)->row();
			$data['biaya'] = $this->laporan_model->getDataPengeluaranRinci1($tanggal);
		}
		$this->load->view('laporan/profit', $data);
	}

	public function rekap() {
		$this->load->model('grafik_model');
		$data['year'] = date('Y');
		$data['bulan'] = date('m');
		$data['tahun'] = $this->grafik_model->getTahunJual()->result_array();
		$this->load->view('header', $data, FALSE);
		$this->load->view('laporan/pilih_bulan');
	}

	public function rekapitulasi_penjualan() {
		$tahun = $this->input->post('tahun');
		$bulan = $this->input->post('bulan');
		$data_rekap = $this->laporan_model->getDataRekap($tahun, $bulan)->result();
		$data['diskon'] = $this->laporan_model->getDiskon($tahun, $bulan)->result();
		$data['toko'] = $this->laporan_model->get_toko();
		$data['tahun'] = $tahun;
		$data['bulan'] = $bulan;
		$data['rekap'] = $data_rekap;
		$data['aa'] = 0;
		$data['bb'] = 0;
		$data['cc'] = 0;
		$data['dd'] = 0;
		$data['ee'] = 0;
		$data['ff'] = 0;
		$data['gg'] = 0;
		$data['tot'] = 0;
		$data['tot_a'] = 0;
		$data['tot_b'] = 0;
		$data['tot_c'] = 0;
		$data['tot_d'] = 0;
		$data['tot_tot'] = 0;
		$data['biaya'] = $this->laporan_model->getDataPengeluaranRekapitulasi($tahun, $bulan);
		$this->load->view('laporan/lap_rekap', $data, FALSE);
	}

}

/* End of file Laporan.php */
/* Location: ./application/controllers/Laporan.php */